/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IETags;
import org.infernalstudios.infernalexp.mixin.common.PaintingAccessor;
import org.infernalstudios.infernalexp.network.IENetworkHandler;
import org.infernalstudios.infernalexp.network.SpawnInfernalPaintingPacket;

public class InfernalPaintingEntity
extends Painting {
    public InfernalPaintingEntity(EntityType<? extends InfernalPaintingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public InfernalPaintingEntity(Level worldIn, BlockPos pos, Direction facing) {
        this((EntityType<? extends InfernalPaintingEntity>)((EntityType)IEEntityTypes.INFERNAL_PAINTING.get()), worldIn);
        this.f_31698_ = pos;
        this.m_6022_(facing);
        ArrayList<Holder> paintings = new ArrayList<Holder>();
        int maxSurfaceArea = 0;
        for (Holder variant : Registry.f_235728_.m_203561_(IETags.Paintings.INFERNAL_PLACEABLE)) {
            ((PaintingAccessor)((Object)this)).invokeSetVariant((Holder<PaintingVariant>)variant);
            this.m_6022_(facing);
            if (!this.m_7088_()) continue;
            paintings.add(variant);
            int surfaceArea = ((PaintingVariant)variant.m_203334_()).m_218908_() * ((PaintingVariant)variant.m_203334_()).m_218909_();
            if (surfaceArea <= maxSurfaceArea) continue;
            maxSurfaceArea = surfaceArea;
        }
        if (!paintings.isEmpty()) {
            Iterator iterator = paintings.iterator();
            while (iterator.hasNext()) {
                PaintingVariant paintingType = (PaintingVariant)((Holder)iterator.next()).m_203334_();
                if (paintingType.m_218908_() * paintingType.m_218909_() >= maxSurfaceArea) continue;
                iterator.remove();
            }
            ((PaintingAccessor)((Object)this)).invokeSetVariant((Holder<PaintingVariant>)((Holder)paintings.get(this.f_19796_.m_188503_(paintings.size()))));
        }
        this.m_6022_(facing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfernalPaintingEntity(Level world, BlockPos pos, Direction facing, PaintingVariant art) {
        this(world, pos, facing);
        ((PaintingAccessor)((Object)this)).invokeSetVariant((Holder<PaintingVariant>)Holder.m_205709_((Object)art));
        this.m_6022_(facing);
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (brokenEntity instanceof Player) {
                Player player = (Player)brokenEntity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19998_((ItemLike)IEItems.INFERNAL_PAINTING.get());
        }
    }

    public Packet<?> m_5654_() {
        return IENetworkHandler.INSTANCE.toVanillaPacket((Object)new SpawnInfernalPaintingPacket(this), NetworkDirection.PLAY_TO_CLIENT);
    }

    public ItemStack getPickedResult(HitResult target) {
        return ((Item)IEItems.INFERNAL_PAINTING.get()).m_7968_();
    }
}

